/*
 * Decompiled with CFR 0.152.
 */
package at.tuwien;

import at.tuwien.Client;
import java.util.StringJoiner;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.UserModel;

public class CreateEventListenerProvider
implements EventListenerProvider {
    private static final Logger log = Logger.getLogger(CreateEventListenerProvider.class);
    private final KeycloakSession session;
    private final RealmProvider model;

    public CreateEventListenerProvider(KeycloakSession session) {
        this.session = session;
        this.model = session.realms();
    }

    public void onEvent(Event event) {
        if (EventType.REGISTER.equals((Object)event.getType()) || EventType.IDENTITY_PROVIDER_FIRST_LOGIN.equals((Object)event.getType())) {
            event.getDetails().forEach((key, value) -> log.debugf("%s : %s", key, value));
            RealmModel realm = this.model.getRealm(event.getRealmId());
            UserModel user = this.session.users().getUserById(realm, event.getUserId());
            this.sendUserData(user);
        }
    }

    public void onEvent(AdminEvent adminEvent, boolean b) {
        log.debug((Object)"onEvent(AdminEvent)");
        log.debugf("Resource path: %s", (Object)adminEvent.getResourcePath());
        log.debugf("Resource type: %s", (Object)adminEvent.getResourceType());
        log.debugf("Operation type: %s", (Object)adminEvent.getOperationType());
        log.debugf("AdminEvent.toString(): %s", (Object)this.toString(adminEvent));
        if (ResourceType.USER.equals((Object)adminEvent.getResourceType()) && OperationType.CREATE.equals((Object)adminEvent.getOperationType())) {
            RealmModel realm = this.model.getRealm(adminEvent.getRealmId());
            UserModel user = this.session.users().getUserById(realm, adminEvent.getResourcePath().substring(6));
            this.sendUserData(user);
        }
    }

    private void sendUserData(UserModel user) {
        String userData = "{" + CreateEventListenerProvider.quoteAttr("id", user.getId()) + ", " + CreateEventListenerProvider.quoteAttr("username", user.getUsername()) + ", " + CreateEventListenerProvider.quoteAttr("ldap_id", user.getFirstAttribute("LDAP_ID")) + ", " + CreateEventListenerProvider.quoteAttr("given_name", user.getFirstName()) + ", " + CreateEventListenerProvider.quoteAttr("family_name", user.getLastName()) + "}";
        try {
            log.debugf("create new user in API: %s", (Object)userData);
            Client.postService(userData);
        }
        catch (Exception e) {
            log.errorf("Failed to call API: %s", (Object)e);
        }
    }

    private static String quoteAttr(String key, String value) {
        if (value == null || value.isBlank() || value.isEmpty() || value.contentEquals(" ")) {
            return "\"" + key + "\": null";
        }
        return "\"" + key + "\": \"" + value + "\"";
    }

    public void close() {
    }

    private String toString(Event event) {
        StringJoiner joiner = new StringJoiner(", ");
        joiner.add("type=" + String.valueOf(event.getType())).add("realmId=" + event.getRealmId()).add("clientId=" + event.getClientId()).add("userId=" + event.getUserId()).add("ipAddress=" + event.getIpAddress());
        if (event.getError() != null) {
            joiner.add("error=" + event.getError());
        }
        if (event.getDetails() != null) {
            event.getDetails().forEach((key, value) -> {
                if (value == null || !value.contains(" ")) {
                    joiner.add(key + "=" + value);
                } else {
                    joiner.add(key + "='" + value + "'");
                }
            });
        }
        return joiner.toString();
    }

    private String toString(AdminEvent event) {
        RealmModel realm = this.model.getRealm(event.getRealmId());
        UserModel newRegisteredUser = this.session.users().getUserById(realm, event.getAuthDetails().getUserId());
        StringJoiner joiner = new StringJoiner(", ");
        joiner.add("operationType=" + String.valueOf(event.getOperationType())).add("realmId=" + event.getAuthDetails().getRealmId()).add("clientId=" + event.getAuthDetails().getClientId()).add("userId=" + event.getAuthDetails().getUserId());
        if (newRegisteredUser != null) {
            joiner.add("email=" + newRegisteredUser.getEmail()).add("username=" + newRegisteredUser.getUsername()).add("firstName=" + newRegisteredUser.getFirstName()).add("lastName=" + newRegisteredUser.getLastName());
        }
        joiner.add("ipAddress=" + event.getAuthDetails().getIpAddress()).add("resourcePath=" + event.getResourcePath());
        if (event.getError() != null) {
            joiner.add("error=" + event.getError());
        }
        return joiner.toString();
    }
}

