/*
 * Decompiled with CFR 0.152.
 */
package at.tuwien;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Base64;
import org.jboss.logging.Logger;

public class Client {
    private static final Logger log = Logger.getLogger(Client.class);

    public static void postService(String data) throws IOException {
        try {
            String output;
            String urlString = System.getenv("METADATA_SERVICE_ENDPOINT");
            log.debugf("METADATA_SERVICE_ENDPOINT: %s", (Object)urlString);
            if (urlString == null || urlString.isEmpty()) {
                throw new IllegalArgumentException("Environment variable METADATA_SERVICE_ENDPOINT is not set or is empty.");
            }
            String systemUsername = System.getenv("SYSTEM_USERNAME");
            if (systemUsername == null || systemUsername.isEmpty()) {
                throw new IllegalArgumentException("Environment variable SYSTEM_USERNAME is not set or is empty.");
            }
            log.debugf("SYSTEM_USERNAME: %s", (Object)systemUsername);
            String systemPassword = System.getenv("SYSTEM_PASSWORD");
            if (systemPassword == null || systemPassword.isEmpty()) {
                throw new IllegalArgumentException("Environment variable SYSTEM_PASSWORD is not set or is empty.");
            }
            URL url = URI.create(urlString + "/api/user").toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            String token = systemUsername + ":" + systemPassword;
            conn.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(token.getBytes(Charset.defaultCharset())));
            conn.setRequestProperty("Content-Type", "application/json; utf-8");
            OutputStream os = conn.getOutputStream();
            os.write(data.getBytes());
            os.flush();
            int responseCode = conn.getResponseCode();
            if (responseCode != 201 && responseCode != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + responseCode);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            log.debugf("Output from Server .... \n", new Object[0]);
            while ((output = br.readLine()) != null) {
                System.out.println(output);
                log.debugf("Input from Server: %s", (Object)output);
            }
            conn.disconnect();
        }
        catch (IOException e) {
            throw new IOException("Failed to post service: " + e.getMessage(), e);
        }
    }
}

